Utils.Ajax=Class.create();
Utils.Ajax.prototype={
	httpObject:Object(),
	loadingImage:'ajax_loading.gif',
	withOverlay:1,
	onSuccess:Object(),
	onFailure:Object(),
	timeOut:1,
	timeOutDelay:15000,
	caller:Object(),
	url:'',
	params:'',
	request_uri:'',
	initialize:function(caller, url, params, onSuccessFuncObj, onFailureFuncObj){
		this.caller=caller;
		this.url=url;
		if (typeof params=='string' && params!=''){
			this.params=params;
		}
		if (typeof onSuccessFuncObj =='function'){
			this.caller.onSuccess=onSuccessFuncObj;
		}
		if (typeof onFailureFuncObj =='function'){
			this.caller.onFailure=onFailureFuncObj;
		}
		this.httpObject=this.getHTTPObject();
	},
	getHTTPObject:function(){
		if (typeof XMLHttpRequest != 'undefined') {
			return new XMLHttpRequest();
		}
		try {
			return new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e) {
			try {
				return new ActiveXObject("Microsoft.XMLHTTP");
			} catch (ex) {
				return false;
			}
		}
	},
	createOverlay:function(){
		windowSizes=Utils.ViewPort.get();
		oCtr=$Ce('div');
		try{
			oCtr.className='ajax-overlay-container';
		} catch(ex){
			oCtr.setAttribute('class', 'ajax-overlay-container');
		}
		oCtr.style.height=document.body.offsetHeight+'px';
		oMsg=$Ce('div');
		try{
			oMsg.className='ajax-overlay-message';
		} catch(ex){
			oMsg.setAttribute('class','ajax-overlay-message');
		}
		oMsg.appendChild(document.createTextNode('Adatletlts folyamatban...'));
		oMsg.appendChild($Ce('br'));
		oImg=$Ce('img');
		oImg.setAttribute('src', ImageUrl+this.loadingImage);
		oMsg.appendChild(oImg);
		oCtr.appendChild(oMsg);
		document.body.appendChild(oCtr);
		VateraEvent.add(oImg, 'load', this.centerOverlay, oMsg);
		VateraEvent.add(window, 'scroll', this.centerOverlay, oMsg);
		return oCtr;
	},
	centerOverlay:function(myObj, myEvent, imgObj){
		windowSizes=Utils.ViewPort.get();
		var scrOfX = 0, scrOfY = 0;
		if( typeof( window.pageYOffset ) == 'number' ) {
			//Netscape compliant
			scrOfY = window.pageYOffset;
			scrOfX = window.pageXOffset;
		} else if( document.body && ( document.body.scrollLeft || document.body.scrollTop ) ) {
			//DOM compliant
			scrOfY = document.body.scrollTop;
			scrOfX = document.body.scrollLeft;
		} else if( document.documentElement && ( document.documentElement.scrollLeft || document.documentElement.scrollTop ) ) {
			//IE6 standards compliant mode
			scrOfY = document.documentElement.scrollTop;
			scrOfX = document.documentElement.scrollLeft;
		}
		oTop=Math.floor((windowSizes[1]/2)-(imgObj.offsetHeight/2))+scrOfY;
		oLeft=Math.floor(windowSizes[0]/2)-Math.floor(imgObj.offsetWidth/2)+scrOfX;
		imgObj.style.top=oTop+'px';
		imgObj.style.left=oLeft+'px';
	},
	destroyOverlay:function(overlayObject){
		overlayObject.parentNode.removeChild(overlayObject);
	},
	call:function(){
		if (!this.httpObject){
			return false;
		}
		if (this.withOverlay==1){
			this.caller.overlayImage=this.createOverlay(this.loadingImage);
		}
		this.request_uri=this.url+''+this.params;
		this.send();
	},
	httpStateChange:function(myObject, myEvent, callbackObj){
		switch (callbackObj.caller.http.readyState){
			case 4:
				callbackObj.clearTimeout();
				if (callbackObj.caller.http.status==200 && typeof callbackObj.caller.onSuccess!='undefined'){
					callbackObj.caller.onSuccess(callbackObj.caller);
				} else if (callbackObj.caller.http.status!=0 && typeof callbackObj.caller.onFailure!='undefined'){
					//any other failure reason
					callbackObj.caller.onFailure(callbackObj.caller);
				}
				if (this.withOverlay==1){
					callbackObj.destroyOverlay(callbackObj.caller.overlayImage);
				}
			default:
				break;
		}
	},
	send:function(){
		this.caller.http=this.httpObject;
		this.caller.http.open("GET", this.request_uri, true);
		try{
			callbackObj=this;
			this.caller.http.onreadystatechange=function(Event){callbackObj.httpStateChange('', '', callbackObj);};
		} catch(ex){
			VateraEvent.add(this.caller.http, 'readystatechange',this.httpStateChange, this);
		}
		this.caller.http.send(null);
		this.initTimeout();
	},
	initTimeout:function(){
		document.ajaxObj=this.caller;
		this.caller.timer=setTimeout('Utils.Ajax.prototype.abortQuery()', this.timeOutDelay);
	},
	clearTimeout:function(){
		clearTimeout(this.caller.timer);
	},
	abortQuery:function(){
		document.ajaxObj.http.abort();
		clearTimeout(document.ajaxObj.timer);
		if (document.ajaxObj.overlayImage){
			Utils.Ajax.prototype.destroyOverlay(document.ajaxObj.overlayImage);
		}
	}
}